/*******************************************************************************
 *
 *      A U D I O   R E C O R D E R
 *
 *      Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef TOUCHSCREEN_H
#define	TOUCHSCREEN_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "genericTypeDefs.h"

/* calibration data structure */
typedef struct {
    INT32   xscale;
    INT32   xoffset;
    INT32   yscale;
    INT32   yoffset;
} TOUCH_CAL_T;

/** Touchscren sleep / wake
 * Puts touchscreen in sleep mode and then puts CPU to sleep. Returns when CPU
 * woken by a touch */
void tchSleepWake(void);

/** Get Battery Voltage
 *  @returns state    - battery state string */
UINT8* tchGetBatt(void);

/** USB Power Connected? */
UINT32 tchGetVUSB(void);

/** 3V Power Good ?*/
UINT8 tchGetPgood(void);

#ifdef	__cplusplus
}
#endif

#endif	/* TOUCHSCREEN_H */

